<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use App\Models\ScheduleMeeting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Volunteer;
use Validator;
use Hash;
use DB;
use Session;
use App\Exports\PostExport;
use App\Exports\NotesExport;
use App\Exports\VolunteerExport;
use Maatwebsite\Excel\Facades\Excel;


class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.login');
    }

	public function exportExcel()
	{
	return Excel::download(new PostExport, 'list.xlsx');
	}
	
	public function exportNotes()
	{
	return Excel::download(new NotesExport, 'Notes.xlsx');
	}
	
	public function exportVolunteers()
	{
	return Excel::download(new VolunteerExport, 'Volunteers.xlsx');
	}
	
	
	
	




	public function login_post(Request $request)
{

$credentials = $request->only('email','password');
if(Auth::attempt($credentials)){
if(Auth::user()->role_id == 1){
$useLoginId=User::where(['email'=>$request->email])->get();

session()->put('admin-login-id',$useLoginId[0]->id);
return redirect(url('admin-dashboard'));

}else{
Session::flush();
Auth::logout();
\Session::put('err_msg','Invalid Username and Password.');
//return redirect(url('admin-login'));

return redirect()->route('admin-login');
}
}else{
\Session::put('err_msg','Invalid Username and Password.');
return redirect(url('admin-login'));
}
}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */



	  public function admin_dashboard()
    {
        $data['users'] = Customer::all();
        $data['volunteers'] = Volunteer::all();
        $data['schedules'] = ScheduleMeeting::all();
       return view('admin.dashboard',$data);
    }

	public function user_index()
    {
		$data['user'] = DB::table('customers')->orderBy('id','desc')->get();
        return view('admin.user.index',$data);
    }





	public function logout()
	{
	Auth::logout();
	Session::flush();
	return redirect(url('admin-login'));
	}

    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function edit_user($id){
        $userData = DB::table('customers')
                    ->where('id', "=", $id)
                    ->get();
        return view('admin.user.view', ['userData'=>$userData]);
    }

    public function update_user(Request $request){
        $ch = DB::table('customers')
                ->where('id', "=", $request->id)
                ->update(
                    array(
                        'name'=>$request->name,
                        'phone'=>$request->phone,
                        'email'=>$request->email,
                        'location'=>$request->location,
                        'address'=>$request->address
            		));
        if($ch){
            \Session::put('success','Data Updated Successfully.');
            return redirect('/user');
        }else{
            \Session::put('warning','Something Gone Wrong.');
            return redirect('/user');
        }
    }

    public function delete_user($id){
        $ch = DB::table('customers')
                ->where('id', "=", $id)->delete();

        if($ch){
            \Session::put('success','Data Deleted Successfully.');
            return redirect('/user');
        }
        else{
            \Session::put('warning','Something Gone Wrong.');
            return redirect('/user');
        }
    }

    public function add_user(){
        return view('admin.user.add');
    }

    public function post_user(Request $request)
    {
        $check = DB::table('customers')
                ->where('email', "=", $request->email)->first();
        if($check == null){
            $insert = DB::table('customers')->insert(
            		array(
            		    'name'=>$request->name,
                        'phone'=>$request->phone,
                        'email'=>$request->email,
                        'password'=>bcrypt($request->password),
                        'location'=>$request->location,
                        'address'=>$request->address
            		));
            if($insert){
                \Session::put('success','Data Store Successfully.');
                return redirect('/user');
            }else{
                \Session::put('warning','Something Gone Wrong.');
                return redirect('/user');
            }
        }
        else{
            \Session::put('warning','Data Already Exist.');
            return redirect('/user');
        }
    }

    /*-------- Volunteer ---------*/
    public function volunteer_index()
    {
		$data['user'] = DB::table('volunteers')->where('delete_status','0')->orderBy('id','desc')->get();
        return view('admin.volunteer.index',$data);
    }

    public function add_volunteer()
	{
        return view('admin.volunteer.add');
    }

    /*public function post_volunteer(Request $request)
    {
        $check = DB::table('volunteers')
                ->where('email', "=", $request->email)->first();
        if($check == null){
            $insert = DB::table('volunteers')->insert(
            		array(
            		    'name'=>$request->name,
                        'phone'=>$request->phone,
                        'email'=>$request->email,
                        'password'=>bcrypt($request->password),
                        'location'=>$request->location,
                        'address'=>$request->address
            		));
            if($insert){
                \Session::put('success','Data Store Successfully.');
                return redirect('/volunteer');
            }else{
                \Session::put('warning','Something Gone Wrong.');
                return redirect('/volunteer');
            }
        }
        else{
            \Session::put('warning','Data Already Exist.');
            return redirect('/volunteer');
        }
    }*/
	
	public function post_volunteer(Request $request)
    {
		
		$validator = Validator::make($request->all(), [ 
		  'phone' => 'required|string|unique:volunteers|min:10|max:15',
		  'email'=>'required|unique:volunteers|min:0|max:50',
		  'name'=>'required|min:0|max:50',
		  'password'=>'required|min:0|max:200',
		  'location'=>'required|min:0|max:200',
		  'address'=>'required|min:0|max:200',
        ]);

         if($validator->fails()){
			return redirect()->back()
			->withErrors($validator)
			->withInput();
			}else{
			
			
			$length = 50;
			$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
			$charactersLength = strlen($characters);
			$randomString = '';
			for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
			}
			$randomString;
			
			$id = DB::table('volunteers')-> insertGetId(
			array(
					'name'=>$request->name,
					'phone'=>$request->phone,
					'email'=>$request->email,
					'password'=>$request->password,
					'location'=>$request->location,
					'token'=>$randomString,
					'delete_status'=>'0',
					'address'=>$request->address
				));
				
				
			
			if($id){
                \Session::put('success','Data Store Successfully.');
                return redirect('/volunteer');
            }else{
                \Session::put('warning','Something Gone Wrong.');
                return redirect('/volunteer');
            }
				
				
		}
		
	}

    public function edit_volunteer($id){
        $userData = DB::table('volunteers')
                    ->where('id', "=", $id)
                    ->get();
        return view('admin.volunteer.view', ['userData'=>$userData]);
    }

    public function update_volunteer(Request $request){
        $ch = DB::table('volunteers')
                ->where('id', "=", $request->id)
                ->update(
                    array(
                        'name'=>$request->name,
                        'phone'=>$request->phone,
                        'email'=>$request->email,
                        'location'=>$request->location,
                        'address'=>$request->address
            		));
        if($ch){
            \Session::put('success','Data Updated Successfully.');
            return redirect('/volunteer');
        }else{
            \Session::put('warning','Something Gone Wrong.');
            return redirect('/volunteer');
        }
    }

    public function delete_volunteer($id){
        $ch = DB::table('volunteers')
                ->where('id',$id)
                ->update(
                    array(
                        'delete_status'=>'1',
						'password'=>'skdjfnsdjkbfkjsdnfkjjdsbfkjdsnkjn'
            		));
        if($ch){
            \Session::put('success','Data Deleted Successfully.');
            //return redirect('/volunteer');
			return redirect()->route('volunteer');
        }else{
            \Session::put('warning','Something Gone Wrong.');
            //return redirect('/volunteer');
			return redirect()->route('volunteer');
        }
    }
    /*-------- Volunteer ---------*/

    /*-------- Schedule ---------*/
    public function schedule_index(){
		
		$data['user'] = DB::table('schedules')->orderBy('id','desc')->get();			
        return view('admin.schedule.index',$data);
    }

    public function add_schedule(){
        $user = DB::table('volunteers')->where('delete_status','!=','1')->get();
        return view('admin.schedule.add', ['user'=>$user]);
    }

    public function post_schedule(Request $request){
		
		
		$validator = Validator::make($request->all(),[ 
		  'employ_name' => 'min:0|max:50',
		  'title'=>'min:0|max:2000',
		  'school_name'=>'min:0|max:200',
		  'description'=>'min:0|max:2000',
        ]);

         if($validator->fails()){
			return redirect()->back()
			->withErrors($validator)
			->withInput();
			}else{
		
		$volunteer_id = $request->volunteer_id;
		$volunteer_id_doesnotexist = DB::table('volunteers')->where('id',$volunteer_id)->doesntExist();
		if($volunteer_id_doesnotexist){
		\Session::put('success','The selected volunteer_id is invalid');
                return redirect('/schedule');
		
		}
		
		
		$volunteer_id = $request->volunteer_id;
		$volunteer_data = DB::table('volunteers')->where('id',$volunteer_id)->get();
		$volunteer_name = $volunteer_data[0]->name;
		
		
	   $from_time = date("g:i a", strtotime($request->from_time));
		
		
		$date = $request->date;
	    $dateformat =  date('l ,F  jS , Y', strtotime($date));
        
		$id = DB::table('schedules')-> insertGetId(array(
		'volunteer_id' => $request->volunteer_id,
		'volunteer_name' => $volunteer_name,
		'employ_name' => $request->employ_name,
		'title' => $request->title,
		'school_name' => $request->school_name,
		'date' => $dateformat,
		'from_time' => $from_time,
		'to_time' => $request->to_time,
		'description' => $request->description,
		'attendence' => '0'
		));
		
		if($id){
                \Session::put('success','Data Store Successfully.');
                return redirect('/schedule');
            }else{
                \Session::put('warning','Something Gone Wrong.');
                return redirect('/schedule');
            }
			
			}
			
			
    }

    public function delete_schedule($id){
        $ch = DB::table('schedules')
                ->where('id', "=", $id)->delete();

        if($ch){
            \Session::put('success','Data Deleted Successfully.');
            return redirect('/schedule');
        }
        else{
            \Session::put('warning','Something Gone Wrong.');
            return redirect('/schedule');
        }
    }

    public function edit_schedule($id){
        $userData = DB::table('schedules')
                    ->join('volunteers', 'schedules.volunteer_id', "=", 'volunteers.id')
                    ->where('schedules.id', "=", $id)
                    ->get(array(
                        'title',
                        'name',
                        'volunteer_id',
                        'date',
                        'from_time',
                        'to_time',
                        'description',
                        'schedules.id'
                    ));
        return view('admin.schedule.view', ['userData'=>$userData]);
    }

    public function update_schedule(Request $request){
        $ch = DB::table('schedules')
                ->where('id', "=", $request->id)
                ->update(
                    array(
                        'title'=>$request->title,
                        'date'=>$request->date,
                        'from_time'=>$request->ftime,
                        'to_time'=>$request->ttime,
                        'description'=>$request->description
            		));
        if($ch){
            \Session::put('success','Data Updated Successfully.');
            return redirect('/schedule');
        }else{
            \Session::put('warning','Something Gone Wrong.');
            return redirect('/schedule');
        }
    }
    /*-------- Schedule ---------*/

    /*-------- assign Volunteer ---------*/
    public function assign_index(){
        $detail = DB::table('assigned_volunteer')
                ->join('customers', 'assigned_volunteer.user_id', "=", 'customers.id')
                ->join('volunteers', 'assigned_volunteer.volunteer_id', "=", 'volunteers.id')
                ->select('customers.name', 'volunteers.name as volunteers_name', 'assigned_volunteer.created_at', 'assigned_volunteer.id')
                ->get();
        return view('admin.assign.index', ['user'=>$detail]);
    }

    public function assign_volunteer(){
        $user = DB::table('customers')->get();
        $volunteer = DB::table('volunteers')->get();
        return view('admin.assign.add', ['user'=>$user], ['volunteer'=>$volunteer]);
    }

    public function postassign_volunteer(Request $request){
        $insert = DB::table('assigned_volunteer')->insert(
            		array(
            		    'user_id'=>$request->user_id,
                        'volunteer_id'=>$request->volunteer_id,
            		));
            if($insert){
                \Session::put('success','Data Store Successfully.');
                return redirect('/assign');
            }else{
                \Session::put('warning','Something Gone Wrong.');
                return redirect('/assign');
            }
    }

    public function deleteassign_volunteer($id){
        $ch = DB::table('assigned_volunteer')
                ->where('id', "=", $id)->delete();

        if($ch){
            \Session::put('success','Data Deleted Successfully.');
            return redirect('/assign');
        }
        else{
            \Session::put('warning','Something Gone Wrong.');
            return redirect('/assign');
        }
    }

    public function editassign_volunteer($id){
        $userData = DB::table('assigned_volunteer')
                ->join('customers', 'assigned_volunteer.user_id', "=", 'customers.id')
                ->join('volunteers', 'assigned_volunteer.volunteer_id', "=", 'volunteers.id')
                ->select('customers.name', 'volunteers.name as volunteers_name', 'assigned_volunteer.created_at', 'assigned_volunteer.id', 'customers.id as cust_id', 'volunteers.id as volun_id')
                ->get();
        $user = DB::table('customers')->get();
        $volunteer = DB::table('volunteers')->get();
        return view('admin.assign.view', ['userData'=>$userData], ['user'=>$user], ['volunteer'=>$volunteer]);
    }

    public function update_assign(Request $request){
        $ch = DB::table('schedules')
                ->where('id', "=", $request->id)
                ->update(
                    array(
                        'title'=>$request->title,
                        'date'=>$request->date,
                        'from_time'=>$request->ftime,
                        'to_time'=>$request->ttime,
                        'description'=>$request->description
            		));
        if($ch){
            \Session::put('success','Data Updated Successfully.');
            return redirect('/schedule');
        }else{
            \Session::put('warning','Something Gone Wrong.');
            return redirect('/schedule');
        }
    }
    /*-------- assign Volunteer ---------*/
    
    /*---------- Notes -------------*/
    /*public function notes_index(){
        $data['notes'] = DB::table('notes')
                        ->join('schedules', 'notes.meeting_id', "=", 'schedules.id')->orderBy('id','desc')->get(array(
                            'notes.id as id',
                            'title',
                            'notes.description as description',
                            'notes.volunteer_id'
        ));			
        return view('admin.notes.index',$data);
    }*/
	
	public function notes_index(){
        $data['notes'] = DB::table('notes')->orderby('id','desc')->get();
                        
        return view('admin.notes.index',$data);
    }
    
    public function add_notes(){
        $volunteer = DB::table('volunteers')->get();
        return view('admin.notes.add', ['volunteer'=>$volunteer]);
    }
    
    public function post_notes(Request $request)
	{
        $insert = DB::table('notes')->insert(
            		array(
            		    'user_id'=>$request->user_id,
                        'title'=>$request->title,
                        'description'=>$request->description,
            		));
            if($insert){
                \Session::put('success','Data Store Successfully.');
                return redirect('/notes');
            }else{
                \Session::put('warning','Something Gone Wrong.');
                return redirect('/notes');
            }
    }
    
    public function editnotes($id){
        $data = DB::table('notes')
                        ->join('volunteers', 'notes.user_id', "=", 'volunteers.id')
                        ->where('notes.id',"=", $id)
                        ->get(array(
                            'notes.id as id',
                            'name as notesname',
                            'title',
                            'user_id',
                            'description'
                        ));
        $volunteer = DB::table('volunteers')->get(array(
            'volunteers.id as volunteer_id',
            'name'
        ));
        return view('admin.notes.view', ['notes'=>$data], ['volunteer'=>$volunteer]);
    }
    
    public function updatenotes(Request $request){
        $notes = DB::table('notes')
                ->where('id', "=", $request->id)
                ->update(
                    array(
                        'user_id'=>$request->user_id,
                        'title'=>$request->title,
                        'description'=>$request->description
            		));
        if($notes){
            \Session::put('success','Data Updated Successfully.');
            return redirect('/notes');
        }else{
            \Session::put('warning','Something Gone Wrong.');
            return redirect('/notes');
        }
    }
    
    public function deletenotes($id){
        $notes_del = DB::table('notes')
                    ->where('id', "=", $id)->delete();
        if($notes_del){
            \Session::put('success','Data Updated Successfully.');
            return redirect('/notes');
        }else{
            \Session::put('warning','Something Gone Wrong.');
            return redirect('/notes');
        }
    }
    /*---------- Notes -------------*/
}
