<?php

namespace App\Rules;

use App\Models\BlockedPeriod;
use Illuminate\Contracts\Validation\Rule;

class IsDateInBlockedPeriod implements Rule
{
    public function passes($attribute, $value)
    {
        return !BlockedPeriod::where('start_date', '<=', $value)
            ->where('end_date', '>=', $value)
            ->exists();
    }

    public function message()
    {
        // Fallback message if no translation found
        return __('validation.custom.appointment_date.is_date_in_blocked_period');
    }

    /**
     * Give this rule a string name so Laravel can look up messages
     */
    public function __toString()
    {
        return 'is_date_in_blocked_period';
    }
}
